/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentManager;
import jade.core.MainContainer;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.mtp.MTPException;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerProxy;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformControllerImpl;
import jade.wrapper.StaleProxyException;

public class ContainerController {
    private AgentContainer myImpl;
    private ContainerProxy myProxy;
    private String myPlatformName;
    protected PlatformController myPlatformController;

    public ContainerController(ContainerProxy cp, AgentContainer impl, String platformName) {
        this.myProxy = cp;
        this.myImpl = impl;
        this.myPlatformName = platformName;
    }

    public AgentController getAgent(String localAgentName) throws ControllerException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID agentID = new AID(localAgentName, false);
        Agent instance = this.myImpl.acquireLocalAgent(agentID);
        if (instance == null) {
            throw new ControllerException("Agent " + localAgentName + " not found.");
        }
        this.myImpl.releaseLocalAgent(agentID);
        return new AgentController(agentID, this.myProxy, this.myImpl);
    }

    public AgentController createNewAgent(String nickname, String className, Object[] args) throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID agentID = new AID(nickname, false);
        try {
            this.myProxy.createAgent(agentID, className, args);
            return new AgentController(agentID, this.myProxy, this.myImpl);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public AgentController acceptNewAgent(String nickname, Agent anAgent) throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        AID agentID = new AID(nickname, false);
        try {
            NodeDescriptor nd = this.myImpl.getNodeDescriptor();
            this.myImpl.initAgent(agentID, anAgent, nd.getOwnerPrincipal(), null);
        }
        catch (Exception e) {
            throw new StaleProxyException(e);
        }
        return new AgentController(agentID, this.myProxy, this.myImpl);
    }

    public void kill() throws StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.killContainer();
            this.myProxy = null;
            this.myImpl = null;
            this.myPlatformName = null;
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void installMTP(String address, String className) throws MTPException, StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.installMTP(address, className);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void uninstallMTP(String address) throws MTPException, NotFoundException, StaleProxyException {
        if (this.myImpl == null || this.myProxy == null) {
            throw new StaleProxyException();
        }
        try {
            this.myProxy.uninstallMTP(address);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public String getPlatformName() {
        return this.myPlatformName;
    }

    public String getContainerName() throws ControllerException {
        if (this.myImpl == null) {
            throw new ControllerException("Stale proxy.");
        }
        return this.myImpl.here().getName();
    }

    public PlatformController getPlatformController() throws ControllerException {
        this.initPlatformController();
        return this.myPlatformController;
    }

    protected void initPlatformController() throws ControllerException {
        if (this.myPlatformController == null) {
            if (this.myImpl == null) {
                throw new ControllerException("Stale proxy.");
            }
            MainContainer main = this.myImpl.getMain();
            if (main == null) {
                throw new ControllerException("Not a Main Container.");
            }
            if (main instanceof AgentManager) {
                this.myPlatformController = new PlatformControllerImpl(this, (AgentManager)((Object)main));
            } else {
                throw new ControllerException("Platform not accessible.");
            }
        }
    }
}

